<?php
/*
* Plugin Name: Notice Widget
* Plugin URI: https://plugins.enakat.com/notice/notice-widget-plugin/
* Description: このプラグインは、カスタム投稿タイプ「notice (お知らせ)」を作成し、登録されたお知らせをリスト形式で表示するためのショートコードを提供します。
* Version: 1.0.0
* Author: Enakat
* Author URI: https://enakat.com/
* License: GPL2 or later
* License URI: https://www.gnu.org/licenses/gpl-2.0.html
* Text Domain: notice-widget
*/

function create_post_type() {
    register_post_type( 'notice',
        array(
            'labels' => array(
                'name' => __( 'お知らせ' ),
                'singular_name' => __( 'お知らせ' )
            ),
            'public' => true,
            'has_archive' => true,
            'supports' => array( 'title', 'editor', 'thumbnail' ),
            'menu_position' => 5,
            'menu_icon' => 'dashicons-list-view',
            'show_in_rest' => true,
        )
    );
}
add_action( 'init', 'create_post_type' );
function notice_list_shortcode() {
    $args = array(
        'post_type' => 'notice',
        'post_status' => 'publish',
        'posts_per_page' => -1, 
    );

    $query = new WP_Query($args);

    if ($query->have_posts()) {
        $output = '<div class="notice-list-container"><ul>';
        while ($query->have_posts()) {
            $query->the_post();
            $output .= '<li>';
            $output .= '<a href="' . get_permalink() . '">';
            $output .= '<section class="notice-img">';
            if (has_post_thumbnail()) {
                $output .= get_the_post_thumbnail(get_the_ID(), 'thumbnail');
            }
            $output .= '</section>';
            $output .= '<section class="notice-info">';
            $output .= '<p>' . get_the_title() . '</p>';
            $output .= '<p>' . get_the_date('Y年m月d日') . '</p>';
            $output .= '</section>';
            $output .= '</a>';
            $output .= '</li>';
        }
        $output .= '</ul></div>';
        wp_reset_postdata();
    } else {
        $output = '<p>お知らせはありません。</p>';
    }

    return $output;
}
add_shortcode('notice-list', 'notice_list_shortcode');

function enqueue_notice_widget_styles() {
    wp_enqueue_style(
        'notice-widget-style',
        plugin_dir_url(__FILE__) . 'notice-widget.css'
    );
}
add_action('wp_enqueue_scripts', 'enqueue_notice_widget_styles');

?>